<?php
require_once('../database/dbhelper.php');

$id = $user_id = $fullname = $email = $phone_number = $address = $note = $order_date = $status = $total_money = '';

// Kiểm tra xem người dùng đã nhấn nút "Đặt hàng" chưa
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['place_order'])) {
    // Lấy dữ liệu từ biểu mẫu
    $fullname = isset($_POST['fullname']) ? $_POST['fullname'] : '';
    $email = isset($_POST['email']) ? $_POST['email'] : '';
    $phone_number = isset($_POST['phone_number']) ? $_POST['phone_number'] : '';
    $address = isset($_POST['address']) ? $_POST['address'] : '';
    $note = isset($_POST['note']) ? $_POST['note'] : '';
    $total_money = isset($_POST['total_money']) ? $_POST['total_money'] : '';
    
    //Lưu thông tin đơn hàng vào cơ sở dữ liệu
    $order_date = date('Y-m-d H:i:s'); // Lấy ngày giờ hiện tại
    $status = 'Đang xử lý'; // Mặc định trạng thái đơn hàng là đang chờ xử lý

    // Kiểm tra kết nối đến cơ sở dữ liệu
    $servername = "localhost";
    $username = "root";
    $password = "";
    $dbname = "webbantrangsuc";

    $conn = new mysqli($servername, $username, $password, $dbname);
    if ($conn->connect_error) {
        die("Kết nối đến cơ sở dữ liệu thất bại: " . $conn->connect_error);
    }

    // Thực hiện truy vấn để chèn dữ liệu vào bảng orders
    $sql = "INSERT INTO orders (user_id, fullname, email, phone_number, address, note, order_date, status, total_money) VALUES (NULL, '$fullname', '$email', '$phone_number', '$address', '$note', '$order_date', '$status', '$total_money')";
    execute($sql);

    //xóa giỏ hàng
    unset($_SESSION["cart"]);
    // Chuyển hướng người dùng đến trang hoàn thành đơn hàng
    header("Location: done-pay.php");
    exit();
    
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css" integrity="sha512-xh6O/CkQoPOWDdYTDqeRdPCVd1SpvCA9XXcUnZS2FmJNp1coAFzvtCN9BmamE+4aHK8yyUHUSCcJHgXloTyT2A==" crossorigin="anonymous" referrerpolicy="no-referrer" >
    <script src="https://kit.fontawesome.com/41e46c9144.js" crossorigin="anonymous"></script>
    <link rel='stylesheet' href="/BTLWEB/css/home.css"/>
    <link rel='stylesheet' href="/BTLWEB/css/cart-pay.css"/>
    <title>Thanh toán đơn hàng</title>
</head>
<style>
    .form-control {
        height: 30px;
        border: 1px solid black;
    }
   
</style>
<body>
    <!-- HEADER -->
    <?php
    include "../authen/signin_submit.php";
    if (isset($_SESSION["email"])&& isset($_SESSION['role']) && $_SESSION['role'] == '0') {
    // user đã đăng nhập thành công
        echo require "header_user.php";
    } else {
    // Chưa đăng nhập
        echo require "header.php";
            }
    ?>

    <!-- CONTENT -->
    <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" style="display:flex">
        <div class="content">
            <!-- Main Content -->
            <div class="wrap">
                <main class="main">
                    <div class="main__content">
                        <!-- Form -->
                        <div class="section__header">
                            <div class="layout-flex">
                                <h2 class="section__title layout-flex__item layout-flex__item--stretch">
                                    Thông tin mua hàng
                                </h2>
                            </div>
                        </div>
                        
                        <div class="section__content">
                            <div class="fieldset">
                                <div class="field field--show-floating-label ">
                                    <div class="field__input-wrapper">
                                        <label for="fullname" class="field__label">Họ và tên</label>
                                        <input type="text" class="form-control" id="fullname" name="fullname" value="<?=$fullname?>" required>
                                    </div>
                                </div>
                                <!-- Email -->
                                <div class="field field--show-floating-label ">
                                    <div class="field__input-wrapper">
                                        <label for="email" class="field__label">Email</label>
                                        <input type="text" class="form-control" id="email" name="email" value="<?=$email?>">
                                    </div>
                                </div>
                                <!-- Phone Number -->
                                <div class="field field--show-floating-label ">
                                    <div class="field__input-wrapper">
                                        <label for="phone_number" class="field__label">Số điện thoại</label>
                                        <input name="phone_number" id="phone_number" type="text" class="form-control" name="phone_number" data-bind="billing.phone" value="<?=$phone_number?>" required>
                                    </div>
                                </div>
                                <!-- Address -->
                                <div class="field field--show-floating-label ">
                                    <div class="field__input-wrapper">
                                        <label for="address" class="field__label">Địa chỉ</label>
                                        <input name="address" id="address" type="text" class="form-control" name="address" data-bind="billing.address" value="<?=$address?>" required>
                                    </div>
                                </div>
                                <!-- Note -->
                                <div class="field field--show-floating-label ">
                                    <div class="field__input-wrapper">
                                        <label for="note" class="field__label">Ghi chú</label>
                                        <textarea name="note" id="note" class="form-control" data-bind="note" class="field__input"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>
            
                <!-- Sidebar -->
                <aside class="sidebar">
                    <div class="sidebar__header">
                        <h2 class="sidebar__title">
                            Đơn hàng 
                        </h2>
                    </div>
                    <div class="sidebar__content">
                        <!-- Order Summary -->
                        <div id="order-summary" class="order-summary order-summary--is-collapsed">
                            <div class="order-summary__sections">
                                <!-- Product List -->
                                <div class="order-summary__section order-summary__section--product-list order-summary__section--is-scrollable order-summary--collapse-element">
                                    <table class="table">
                                        <!-- Table Header -->
                                        <thead>
                                            <tr>
                                                <th style="width: 100%;"></th>
                                            </tr>
                                        </thead>
                                        <!-- Table Body -->
                                        <tbody>
                                            <?php
                                            require_once('../database/dbhelper.php');

                                            // Truy vấn dữ liệu từ bảng order_details
                                            $sql = "SELECT * FROM order_details";
                                            $orderList = executeResult($sql);

                                            // Hiển thị thông tin sản phẩm trong giỏ hàng
                                            if ($orderList) {
                                                foreach ($orderList as $order) {
                                                    echo "<tr>";
                                                    echo "<td class='text-left' style='text-align: left;'>";
                                                    // Hiển thị hình ảnh sản phẩm và số lượng
                                                    echo "<div class='product-thumbnail'>";
                                                    echo "<div class='product-thumbnail__wrapper' data-tg-static=''>";
                                                    echo "<img src='" . $order['product_thumbnail'] . "' class='product-thumbnail__image' alt='" . $order['product_title'] . "'>";
                                                    echo "</div>";
                                                    echo "<span class='product-thumbnail__quantity'>" . $order['quantity'] . "</span>"; // Số lượng sản phẩm
                                                    echo "</div>";
                                                    // Hiển thị tên sản phẩm
                                                    echo "<a href='productdetail.php?id=" . $order['product_id'] . "' title='" . $order['product_title'] . "'>" . $order['product_title'] . "</a>";
                                                    echo "</td>";
                                                    // Hiển thị thành tiền
                                                    echo "<td class='text-center'>" . number_format($order['total_money'], 0, ',', '.') . "₫</td>";
                                                    echo "</tr>";
                                                }
                                            } else {
                                                echo "<tr><td colspan='2' class='text-center'>Không có sản phẩm trong giỏ hàng.</td></tr>";
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>

                                <!-- Total Lines -->
                                <?php
                                // Tính tổng giá trị của tất cả các mặt hàng trong giỏ hàng
                                $totalPrice = 0;
                                foreach ($orderList as $order) {
                                    $totalPrice += $order['total_money'];
                                }
                                ?>
                                <!-- HTML được cập nhật với tổng giá trị tính được -->
                                <div class="order-summary__section order-summary__section--total-lines order-summary--collapse-element">
                                    <table class="total-line-table">
                                        <caption class="visually-hidden">Tổng giá trị</caption>
                                        <thead>
                                            <tr>
                                                <th>Mô tả</th>
                                                <th>Giá tiền</th>
                                            </tr>
                                        </thead>
                                        <tbody class="total-line-table__tbody">
                                            <tr class="total-line total-line--subtotal">
                                                <td class="total-line__name">Tạm tính</td>
                                                <td class="total-line__price text-center">
                                                    <?php echo number_format($totalPrice, 0, ',', '.') ?>₫
                                                </td>
                                            </tr>
                                            <tr class="total-line total-line--shipping-fee">
                                                <td class="total-line__name">Phí vận chuyển</td>
                                                <td class="total-line__price">-</td>
                                            </tr>
                                        </tbody>
                                        <tfoot class="total-line-table__footer">
                                            <tr class="total-line payment-due">
                                                <th class="total-line__name">
                                                    <span class="payment-due__label-total">Tổng cộng</span>
                                                </th>
                                                <td class="total-line__price text-center" name="total_money">
                                                    <?php echo number_format($totalPrice, 0, ',', '.') ?>₫
                                                </td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>

                                <!-- Order Navigation -->
                                <div class="order-summary__nav field__input-btn-wrapper hide-on-mobile layout-flex--row-reverse">
                                    <button type="submit" class="btn btn-checkout " name="place_order">
                                        <span>ĐẶT HÀNG</span>
                                    </button>
                                    <a href="shopping-cart.php" class="previous-link">
                                        <i class="previous-link__arrow">❮</i>
                                        <span class="previous-link__content">Quay về giỏ hàng</span>
                                    </a>
                                </div>
                                
                            </div>
                        </div>
                    </div>
                </aside>
            </div>
        </div>
    </form>

    <!-- Footer -->
    <?php
            require "footer.php";
    ?>
<!-- Script để xử lý yêu cầu AJAX -->
    <!-- Script để xử lý yêu cầu AJAX -->
    <script>
    document.getElementById('order-form').addEventListener('submit', function(event) {
        event.preventDefault(); // Ngăn chặn gửi yêu cầu mặc định của biểu mẫu

        var formData = new FormData(this); // Lấy dữ liệu từ biểu mẫu

        // Gửi yêu cầu AJAX đến server
        var xhr = new XMLHttpRequest();
        xhr.onreadystatechange = function() {
            if (this.readyState === XMLHttpRequest.DONE && this.status === 200) {
                alert(this.responseText); // Hiển thị thông báo từ server
                // Nếu muốn chuyển hướng sau khi đặt hàng thành công, sử dụng window.location.href = "done-pay.html";
            }
        };
        xhr.open('POST', 'cart-pay-ajax.php', true);
        xhr.send(formData); // Gửi dữ liệu form đến server
    });
    </script>
</body>
</html>
